﻿/*
@@@BUILDINFO@@@ "illustrator-19.0.jsx" 2.0.0.221 12-Jun-2007 
*/

/*
@@@START_XML@@@
<?xml version="1.0" encoding="UTF-8"?>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="en_US">
     <dc:title>Adobe Illustrator CC</dc:title>
     <dc:description>This script enables other applications to communicate with Adobe Illustrator CC.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="cs_CZ">
     <dc:title>Adobe Illustrator CC</dc:title>
     <dc:description>Tento skript umožňuje jiným aplikacím komunikovat s programem Adobe Illustrator CC.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="de_DE">
     <dc:title>Adobe Illustrator CC</dc:title>
     <dc:description>Dieses Skript ermöglicht es anderen Anwendungen, mit Adobe Illustrator CC zu kommunizieren.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="es_ES">
     <dc:title>Adobe Illustrator CC</dc:title>
     <dc:description>El archivo de comandos permite a otras aplicaciones comunicarse con Adobe lllustrator CC.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fr_FR">
     <dc:title>Adobe Illustrator CC</dc:title>
     <dc:description>Ce script permet à d'autres applications de communiquer avec Adobe Illustrator CC.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="hu_HU">
     <dc:title>Adobe Illustrator CC</dc:title>
     <dc:description>Ez a parancsfájl lehetővé teszi más alkalmazások számára, hogy kommunikáljanak az Adobe Illustrator CC programmal.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="it_IT">
     <dc:title>Adobe Illustrator CC</dc:title>
     <dc:description>Questo script consente ad altre applicazioni di comunicare con Adobe Illustrator CC.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ko_KR">
     <dc:title>Adobe Illustrator CC</dc:title>
     <dc:description>이 스크립트는 다른 응용 프로그램이 Adobe Illustrator CC에 연결하도록 해줍니다.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="nl_NL">
     <dc:title>Adobe Illustrator CC</dc:title>
     <dc:description>Met dit script kunnen andere toepassingen communiceren met Adobe Illustrator CC.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="pl_PL">
     <dc:title>Adobe Illustrator CC</dc:title>
     <dc:description>Ten skrypt umożliwia innym aplikacjom komunikację z programem Adobe Illustrator CC.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="pt_BR">
     <dc:title>Adobe Illustrator CC</dc:title>
     <dc:description>Este script permite que outros aplicativos se comuniquem com o Adobe Illustrator CC.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ru_RU">
     <dc:title>Adobe Illustrator CC</dc:title>
     <dc:description>Этот сценарий позволяет другим приложениям взаимодействовать с Adobe Illustrator CC.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="tr_TR">
     <dc:title>Adobe Illustrator CC</dc:title>
     <dc:description>Bu komut dosyası, diğer uygulamaları Adobe Illustrator CC ile iletişim kurmaları için etkinleştirir.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="uk_UA">
     <dc:title>Adobe Illustrator CC</dc:title>
     <dc:description>Цей сценарій забезпечує обмін даними між Adobe Illustrator CC та іншими програмами.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="zh_CN">
     <dc:title>Adobe Illustrator CC</dc:title>
     <dc:description>该脚本使其他应用程序可以与 Adobe Illustrator CC 通信。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="zh_TW">
     <dc:title>Adobe Illustrator CC</dc:title>
     <dc:description>此指令可讓其他應用程式和 Adobe Illustrator CC 通訊。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="da_DK">
     <dc:title>Adobe Illustrator CC</dc:title>
     <dc:description>Dette script gør det muligt for andre programmer at kommunikere med Adobe Illustrator CC.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="sv_SE">
     <dc:title>Adobe Illustrator CC</dc:title>
     <dc:description>Det här skriptet gör att andra program kan kommunicera med Adobe Illustrator CC.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ja_JP">
     <dc:title>Adobe Illustrator CC</dc:title>
     <dc:description>このスクリプトを使用して、他のアプリケーションと Adobe Illustrator CC を通信させることができます。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ar_AE">
     <dc:title>Adobe Illustrator CC</dc:title>
     <dc:description>هذا النص التنفيذي يتيح للتطبيقات الأخرى التواصل مع Adobe Illustrator CC.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="el_GR">
     <dc:title>Adobe Illustrator CC</dc:title>
     <dc:description>Αυτή η δέσμη ενεργειών δίνει τη δυνατότητα σε άλλες εφαρμογές να επικοινωνούν με το Adobe Illustrator CC.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="he_IL">
     <dc:title>Adobe Illustrator CC</dc:title>
     <dc:description>סקריפט זה מאפשר ליישומים אחרים לתקשר עם Adobe Illustrator CC</dc:description>
</ScriptInfo>
@@@END_XML@@@
*/

/*********************************************************************/
/*                                                                   */
/* Copyright (C) 2004 Adobe Systems, Inc. All rights reserved.       */
/*                                                                   */
/* Module Name: illustrator.jsx                                    */
/*                                                                   */
/* Description: Illustrator Cross-DOM implementation for the Bridge. */
/*                                                                   */
/*                                                                   */
/* NOTICE:  All information contained herein or attendant            */
/* hereto is, and remains, the property of Adobe Systems, Inc.       */
/* Many of the intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems, Inc. and may be          */
/* covered by U.S. and Foreign Patents or Patents Pending or         */
/* are protected as trade secrets.  Any dissemination of this        */
/* information or reproduction of this material are strictly         */
/* forbidden unless prior written permission is obtained from        */
/* Adobe Systems, Inc.                                               */
/*                                                                   */
/*********************************************************************/

/**
   Set debugging level: 0-2 (0:disable, 1:break on error, 2:break at beginning)
*/

$.level = 0;

/**
  Guard against loading of multiple revisions of the same startup script. The latest revision
  will take precedence.
*/

try
{ // overall try-catch

if (typeof illustrator != "undefined")
{
	if (illustrator.revision == undefined || 
	    illustrator.revision < 1)	// in-sync: revision # of current startup script
		delete illustrator;
	else
		// bail out right here...
		throw "Object illustrator() has been defined! New definition is ignored.";	
}

illustrator = new Object;
illustrator.revision = 1;			// in-sync: revision # of current startup script									
illustrator.appName = "illustrator";
illustrator.targetName = "illustrator-19";

illustrator.ColorModeRGB = 0;
illustrator.ColorModeCMYK = 1; 

illustrator.LibraryTypeArtwork= 0;
illustrator.LibraryTypeSwatches= 1;
illustrator.LibraryTypeBrushes= 2;
illustrator.LibraryTypeGraphicStyles= 3;
illustrator.LibraryTypeSymbols= 4;



/**
  Do the file open.
  @param  files File or Array of File to be opened.
  @return true if all the files are successfully opened.
*/
illustrator.open = function ( files )
{
    if( BridgeTalk.appName == illustrator.appName )
    {	
		BridgeTalk.bringToFront(illustrator.targetName);

		var fileArray = new Array;
		if (files instanceof File)
			fileArray.push(files);
		else 
			fileArray = files.concat(fileArray);
		
		var reply = true;

 		for( var i = 0; i < fileArray.length; i++ )
		{
			try
			{
				app.open( fileArray[i] );
			}
			catch (err)
			{
				reply = false;
				//rs = ("Error on open(): " + (err.number & 0xFFFF) + ", " + err.description + ", " + fileArray[i].toString() );
				//alert(rs);
			}
		}
		return reply;
	}
	else
	{
		// create a BridgeTalk message for Illustrator to invoke open
		var filesString = illustrator.fileArrayToString ( files );

        var btMessage = new BridgeTalk;
        btMessage.target = illustrator.targetName;
        btMessage.body = "illustrator.open (" + filesString + ");";
        btMessage.onResult = function(bto) {BridgeTalk.bringToFront(bto.sender);}
        btMessage.send();
	}
}


/**
  Do the file open with Options
  @param  files File or Array of File to be opened.
  @return true if all the files are successfully opened.
*/


illustrator.openWithOptions = function ( files, colorspace, library )
{
    if( BridgeTalk.appName == illustrator.appName )
    {	

		BridgeTalk.bringToFront(illustrator.targetName);

		var fileArray = new Array;
		if (files instanceof File)
			fileArray.push(files);
		else 
			fileArray = files.concat(fileArray);
		
		var reply = true;
			
		var aiColorSpace = DocumentColorSpace.CMYK; // Initialize with default value
	
		if( colorspace == illustrator.ColorModeRGB )
			aiColorSpace = DocumentColorSpace.RGB;
		else if( colorspace == illustrator.ColorModeCMYK )
			aiColorSpace = DocumentColorSpace.CMYK;
			
		var openOpts = new OpenOptions;
		openOpts.openAs = LibraryType.SWATCHES;	
		
		if( library == illustrator.LibraryTypeArtwork )
			openOpts.openAs = LibraryType.IllustratorArtwork;
		
		else if( library == illustrator.LibraryTypeSwatches )
			openOpts.openAs = LibraryType.SWATCHES;
		
		else if( library == illustrator.LibraryTypeBrushes )
			openOpts.openAs = LibraryType.BRUSHES;
		
		else if( library == illustrator.LibraryTypeGraphicStyles )
			openOpts.openAs = LibraryType.GRAPHICSTYLES;
		
		else if( library == illustrator.LibraryTypeSymbols )
			openOpts.openAs = LibraryType.SYMBOLS;
			
 		for( var i = 0; i < fileArray.length; i++ )
		{
			try
			{
				app.open( fileArray[i], aiColorSpace, openOpts );
			}
			catch (err)
			{
				reply = false;
				//rs = ("Error on open(): " + (err.number & 0xFFFF) + ", " + err.description + ", " + fileArray[i].toString() );
				//alert(rs);
			}
		}
		return reply;
	}
	else
	{
		// create a BridgeTalk message for Illustrator to invoke open
		var filesString = illustrator.fileArrayToString ( files );

        var btMessage = new BridgeTalk;
        btMessage.target = illustrator.targetName;
        btMessage.body = "illustrator.openWithOptions (" + filesString + "," + colorspace + "," + library + ");";
        btMessage.onResult = function(bto) {BridgeTalk.bringToFront(bto.sender);}
        btMessage.send();
	}
}


/**
  Create a new un-titled document. 
  @param  creationOptions Optional Illustrator specific creation settings [<color space> [<width> <height>]].
  @return true if new artwork is successfully created.
*/
illustrator.openAsNew = function ()
{
    if( BridgeTalk.appName == illustrator.appName )
    {			
       	BridgeTalk.bringToFront(illustrator.targetName);		

		var doc = null;
		
		try
		{
			// handle valid creation options
			if (arguments.length > 0)
			{
				var colorSpace = null;
				var width = 0;
				var height = 0;
				
				// [<color space>]: DocumentColorSpace
				for (var i = 0; i < arguments.length; i++)
				{
					if (typeof(arguments[i]) == "object" && 
					    (arguments[i] == DocumentColorSpace.RGB || arguments[i] == DocumentColorSpace.CMYK))
					{
						colorSpace = arguments[i];
						break;
					}
				}
	           
				// [<width> <height>] : two numbers
				for (var i = 0; i < arguments.length - 1; i++)
				{
					if (typeof(arguments[i]) == "number" && typeof(arguments[i+1]) == "number")
					{
						width = arguments[i];
						height = arguments[i+1];
						break;
					}
				}
				
				if (colorSpace != null && width > 0 && height > 0)
					doc = app.documents.add(colorSpace, width, height);				
				else if (colorSpace != null)
					doc = app.documents.add(colorSpace);
				else
					doc = app.documents.add();					
			}
			else
			{
				doc = app.documents.add();
			}
		}
		catch (err)
		{
			doc = null;
			//rs = ("Error on reveal(): " + (err.number & 0xFFFF) + ", " + err.description );
			//alert(rs);
		}
        if (doc != null)
            return true;
        else
            return false;
	}
	else
	{
		// create a BridgeTalk message for Illustrator to invoke openAsNew
        var btMessage = new BridgeTalk;
        btMessage.target = illustrator.targetName;
        btMessage.body = "illustrator.openAsNew (";
        if (arguments.length > 0)
        {
            for (var i = 0; i < arguments.length; i++)
            {
                btMessage.body += arguments[i].toSource();
            }
        }
        btMessage.body += ");";
        btMessage.onResult = function(bto) {BridgeTalk.bringToFront(bto.sender);}
        btMessage.send();
	}
}

/**
 Place linking files.
 @param  files File or Array of File to be place-linked.
 @return true if all the files are successfully place-linked.
*/
illustrator.place = function ( files )
{
    if( BridgeTalk.appName == illustrator.appName )
    {			
		BridgeTalk.bringToFront(illustrator.targetName);
		
		var fileArray = new Array;
		if (files instanceof File)
			fileArray.push(files);
		else 
			fileArray = files.concat(fileArray);
				
		var reply = false;
		if (app.documents.length == 0)
		{
			app.documents.add();
		}

		reply = true;
		for( var i = 0; i < fileArray.length; i++ )
		{
			try
			{
				var placedArt = app.activeDocument.placedItems.add();
				placedArt.file = fileArray[i];
			}
			catch (err)
			{
				// rollback the earlier actions
				if (placedArt != null && placedArt != undefined)
					placedArt.remove();
					
				reply = false;
				//rs = ("Error on place(): " + (err.number & 0xFFFF) + ", " + err.description + ", " + fileArray[i].toString() );
				//alert(rs);
			}
		}
		return reply;
	}
	else
	{
		// create a BridgeTalk message for Illustrator to invoke place
		var filesString = illustrator.fileArrayToString ( files );

        var btMessage = new BridgeTalk;
        btMessage.target = illustrator.targetName;
        btMessage.body = "illustrator.place (" + filesString + ");";
        btMessage.onResult = function(bto) {BridgeTalk.bringToFront(bto.sender);}
        btMessage.send();
	}
}

/**
  Do the file print.
  @param  files File or Array of File to be printed.
  @return true if all the files are successfully printed.
*/
illustrator.print = function ( files )
{
    if( BridgeTalk.appName == illustrator.appName )
    {			
		BridgeTalk.bringToFront(illustrator.targetName);
			
		var fileArray = new Array;
		if (files instanceof File)
			fileArray.push(files);
		else 
			fileArray = files.concat(fileArray);
			
		var reply = true;
		for( var i = 0; i < fileArray.length; i++ )
		{
			try
			{
				var doc = app.open( fileArray[i] );
				doc.print();
			}
			catch (err)
			{
				reply = false;
				//rs = ("Error on print(): " + (err.number & 0xFFFF) + ", " + err.description + ", " + fileArray[i].toString() );
				//alert(rs);
			}
		}
		return reply;
	}
	else
	{
		// create a BridgeTalk message for Illustrator to invoke print
		var filesString = illustrator.fileArrayToString ( files );

        var btMessage = new BridgeTalk;
        btMessage.target = illustrator.targetName;
        btMessage.body = "illustrator.print (" + filesString + ");";
        btMessage.onResult = function(bto) {BridgeTalk.bringToFront(bto.sender);}
        btMessage.send();
	}
}

/**
  Give the target application focus and bring the specified document to the 
  foreground if it is already open.
  @param  file File to be activated.
  @return true if the file was open and is successfully brought to the foreground.
*/
illustrator.reveal = function ( file )
{
    if( BridgeTalk.appName == illustrator.appName )
    {			
		BridgeTalk.bringToFront(illustrator.targetName);
		
		var reply = false;
		try
		{
			for(var index = 0; index < app.documents.length; index ++)
			{
				var doc = app.documents[index];
				if (doc.fullName.toString() == file.toString())
				{
					doc.activate();
					reply = true;
					break;
				}
			}
		}
		catch (err)
		{
			//rs = ("Error on reveal(): " + (err.number & 0xFFFF) + ", " + err.description + ", " + file.toString() );
			//alert(rs);
		}
		return reply;
	}
	else
	{
		// create a BridgeTalk message for Illustrator to invoke reveal
		var fileString = "File ('" + file.path.toString() + "')";;

        var btMessage = new BridgeTalk;
        btMessage.target = illustrator.targetName;
        btMessage.body = "illustrator.reveal (" + fileString + ");";
        btMessage.onResult = function(bto) {BridgeTalk.bringToFront(bto.sender);}
        btMessage.send();
	}
}

/**
  Shutdown Illustrator.
  @param  none.
  @return none.
*/
illustrator.quit = function ()
{
    if( BridgeTalk.appName == illustrator.appName )
    {			
		try
		{
			app.quit();
		}
		catch (err)
		{
			//rs = ("Error on quit(): " + (err.number & 0xFFFF) + ", " + err.description);
			//alert(rs);
		}
	}
	else
	{
		// create a BridgeTalk message for Illustrator to invoke quit
        var btMessage = new BridgeTalk;
        btMessage.target = illustrator.targetName;
        btMessage.body = "illustrator.quit();";
        btMessage.send();
	}
}

/**
  Execute arbitrary Illustrator JavaScript.
  @param  jsscript The script for the Illustrator to run.
  @return result from evaluating the script.
*/
illustrator.executeScript = function ( jsscript ) 
{
    if( BridgeTalk.appName == illustrator.appName )
    {			
		BridgeTalk.bringToFront(illustrator.targetName);

		try
		{
			return eval(jsscript);
		}
		catch (err)
		{
			//rs = ("Error on executeScript(): " + (err.number & 0xFFFF) + ", " + err.description);
			//alert(rs);
		}
	}
	else
	{
		// create a BridgeTalk message for Illustrator to invoke executeScript
        var btMessage = new BridgeTalk;
        btMessage.target = illustrator.targetName;
        btMessage.body = "illustrator.executeScript(" + jsscript + ");";
        btMessage.onResult = function(bto) {BridgeTalk.bringToFront(bto.sender);}
        btMessage.send();
	}
}

/**
  This routine create a string for the files array that we can transmit
  over BridgeTalk as text, like this:
     Array (File ('path1'), File ('path2'), File ('path3'))
     
  @param  files File or Array of Files.
  @return String.
*/
illustrator.fileArrayToString = function ( files )
{
	var fileArray = new Array;
	if (files instanceof File)
		fileArray.push(files);
	else 
		fileArray = files.concat(fileArray);
    
    	return fileArray.toSource();
}

/**
  This routine sets the argument menu node to be enabled if single item is selected.
*/
illustrator.singleSelectionEnabled = function (menuElement)
{
    menuElement.enabled = false;
    if (app.document != undefined)
    {
		if (app.document.selectionLength == 1)
			menuElement.enabled = true;
	}
}

/**
  This routine sets the argument menu node to be enabled if something is selected.
*/
illustrator.selectionEnabled = function (menuElement)
{
    menuElement.enabled = false;
    if (app.document != undefined)
    {
		if (app.document.selectionLength > 0)
			menuElement.enabled = true;
	}
}
	
/**
  This routine takes an array of thumbnails and returns an array of the
  files represented by those thumbnail objects.

  @param   thumbnails Array of thumbnails.
  @return  Array of Files.
*/
illustrator.thumbnailArrayToFileArray = function (thumbnails)
{
	var filesArray = new Array ();
	for (var index = 0; index < thumbnails.length; index++ )
	{
		// Filter out folders
		if (!thumbnails[index].container)
		{
			if(thumbnails[index].spec != undefined) 
			{
				filesArray.push (thumbnails[index].spec);
			}
		}
	}
		
	return filesArray;
}

/**
  This routine returns the selected files, or if no files are selected,
  all the files.

  @return  Array of Files.
*/
illustrator.getBridgeFileList = function ()
{	
	var files = new Array;
	if (app.document.thumbnail != undefined)
	{
		var thumbnails = new Array;
		thumbnails = app.document.getSelection("*");
		for (var index = 0; index < thumbnails.length; index++ )
		{
			// Filter out folders
			if (!thumbnails[index].container)
			{
				if(thumbnails[index].spec != undefined) 
				{
					files.push (thumbnails[index].spec);
				}
			}
		}
	}
	return files;
}

/**
  This routine takes an array of thumbnails and returns an array of file paths
  represented by those thumbnail objects.

  @param   thumbnails Array of thumbnails.
  @return  Array of Strings.
*/
illustrator.thumbnailArrayToFilePathArray = function (thumbnails)
{
	var filesArray = new Array ();
	
	for (var index = 0; index < thumbnails.length; index++ )
	{
		// Filter out folders
		if (!thumbnails[index].container)
		{
			filesArray.push (thumbnails[index].path);
		}
	}
		
	return filesArray;
}

/**
  This routine returns an array of file paths for the selected files, or if no files are selected,
  all the files.

  @return  Array of Strings.
*/
illustrator.getBridgeFilePathList = function ()
{	
	var files = new Array;
	
	if (app.document.thumbnail != undefined)
	{
		files = illustrator.thumbnailArrayToFilePathArray (app.document.getSelection("*"));
	}
		
	return files;
}
	
/**
  Worker routine to place files from Bridge.
*/
illustrator.placeLinkFromBridge = function ()
{
	var files = new Array;
	if (app.document.thumbnail != undefined)
	{
		var thumbnails = app.document.getSelection("*");
		files = illustrator.thumbnailArrayToFileArray (thumbnails);

		if (files.length == 0)
		{
			alert(localize("$$$/Bridge/Menu/Scripting/Illustrator/NoFilesToPlace=There are no files to place into Illustrator."));
		}
		else
		{
			// preflighting
			app.acquirePhysicalFiles(thumbnails);
			
			// call Illustrator place command
			illustrator.place (files);
		}
	}
}

/**
  Returns true iff the current target app is the highest version installed on the user machine.
*/
illustrator.CheckHighestInstalledTarget = function()
{
	var thisVersionExists = false;
	var higherVersionExists = false;

	if (BridgeTalk.getTargets(null).join().indexOf(illustrator.appName) >= 0)
	{
	    var appTargetVersion = illustrator.targetName.substring(illustrator.targetName.indexOf('-')+1);
	    
		var appSpecifiers = BridgeTalk.getTargets(0);
		for( var i = 0; i < appSpecifiers.length; i++ )
		{
			var appSpecifier = appSpecifiers[i];
			if( appSpecifier.indexOf(illustrator.appName) == 0 )
			{
				// get the version #
				var appVersion = appSpecifier.substring(appSpecifier.indexOf('-')+1)
				
				if (appVersion == appTargetVersion)
				{
					thisVersionExists = true;
				}
				else if (appVersion > appTargetVersion)
				{
					higherVersionExists = true;
				}
			}
		}
	}

	if (!higherVersionExists && thisVersionExists	)
		return true;
	else
		return false;
}

/**
  This routine inserts the "Place/Link to Illustrator" menu item into the Bridge object menu
  and inserts the "Open As AI Library" in right-click context menu for .ai files.
*/
if (BridgeTalk.appName == "bridge")
{
	var placeLinkCmd = MenuElement.create("command", localize("$$$/Bridge/Menu/Scripting/Illustrator/PlaceLink=In Illustrator"), "at the end of submenu/Place", "PlaceLinkInIllustrator");
	placeLinkCmd.onDisplay = function()
	{
		illustrator.selectionEnabled(this);
	}
	placeLinkCmd.onSelect = illustrator.placeLinkFromBridge;
	
	// create illustrator context menu
	var contextMenu = MenuElement.create( "menu", localize("$$$/AI13/MainContextMenu=Open As AI Library"), "-at the end of Thumbnail", "AIContextMenu" );
	contextMenu.onDisplay = function(m) 
	{  
		m.enabled = true;
		try
		{
			m.enabled = app.document.selectionLength > 200 || app.document.getSelection("ai").length > 0;
		} catch(error)
	 	{ 
	 		Window.alert(error); 
	 	}
	}  		
  	
  	// create sub-menu-items
	var	subMenuBrush = MenuElement.create( "command", localize("$$$/AI13/BrushLibrary=AI Brush Library"), "at the end of AIContextMenu", "AIContextMenu/BrushLibrary");
	var	subMenuGraphic = MenuElement.create( "command", localize("$$$/AI13/GraphicLibrary=AI Graphic Library"), "at the end of AIContextMenu", "AIContextMenu/GraphicLibrary");
	var	subMenuSwatch = MenuElement.create( "command", localize("$$$/AI13/SwatchLibrary=AI Swatch Library"), "at the end of AIContextMenu", "AIContextMenu/SwatchLibrary");
	var	subMenuSymbol = MenuElement.create( "command", localize("$$$/AI13/SymbolLibrary=AI Symbol Library"), "at the end of AIContextMenu", "AIContextMenu/SymbolLibrary");


	subMenuBrush.onSelect = function() 
	{
		var thumbnails = app.document.selections;
		app.acquirePhysicalFiles(thumbnails);
		var files = illustrator.thumbnailArrayToFileArray(thumbnails);
		illustrator.openWithOptions(files, illustrator.ColorModeRGB, illustrator.LibraryTypeBrushes);		
	}
	
	subMenuGraphic.onSelect = function() 
	{
		var thumbnails = app.document.selections;
		app.acquirePhysicalFiles(thumbnails);
		var files = illustrator.thumbnailArrayToFileArray(thumbnails);
		illustrator.openWithOptions(files, illustrator.ColorModeRGB, illustrator.LibraryTypeGraphicStyles);
	}
	
	subMenuSwatch.onSelect = function() 
	{
		var thumbnails = app.document.selections;
		app.acquirePhysicalFiles(thumbnails);
		var files = illustrator.thumbnailArrayToFileArray(thumbnails);
		illustrator.openWithOptions(files, illustrator.ColorModeRGB, illustrator.LibraryTypeSwatches);
	}
	
	subMenuSymbol.onSelect = function() 
	{
		var thumbnails = app.document.selections;
		app.acquirePhysicalFiles(thumbnails);
		var files = illustrator.thumbnailArrayToFileArray(thumbnails);
		illustrator.openWithOptions(files, illustrator.ColorModeRGB, illustrator.LibraryTypeSymbols);
	}	
	
}

illustrator.matchesFileExtensions = function ( aThumbnail, extensionsToMatch )
{
	if(aThumbnail.spec == undefined)
	{
		return false;
	}
	
	var period = ".";
	var index = aThumbnail.spec.name.toString().lastIndexOf(period);
	
	if (index > -1)
	{
		ext = aThumbnail.spec.name.substring(index+1).toLowerCase();
		if (extensionsToMatch.length > 0)
		{
			for (var extIndex = 0; extIndex < extensionsToMatch.length; extIndex++ )
			{
				if (ext == extensionsToMatch[extIndex])
					return true;
			}
		}
	}
	return false;
}

illustrator.matchesMacFileType = function ( fileType, fileTypesToMatch )
{	
	if (fileTypesToMatch.length > 0 && fileType != "????" && fileType != "    " && fileType != null)
	{
		for (var i = 0; i < fileTypesToMatch.length; i++ )
		{
			if (fileType == fileTypesToMatch[i])
				return true;
		}
	}
	return false;
}


} // overall try-catch
catch(ex)
{
}

if( BridgeTalk.appName == "illustrator" )
{
	Point = function(x,y) { return new Array( x, y ); }
	Rect = function(l,t,r,b) { return new Array( l,t,r,b ); }
}
